/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util.object;

import dev.toma.gunsrpg.util.object.LazyLoader;
import java.util.Arrays;
import net.minecraft.util.text.TextFormatting;

public class RGB2TextFormatting {
    private static final LazyLoader<TextFormatting[]> COLOR_LOADER = new LazyLoader<TextFormatting[]>(RGB2TextFormatting::initColors);

    public static TextFormatting getClosestFormat(int color) {
        TextFormatting[] colors = COLOR_LOADER.get();
        int minDistIndex = 0;
        int minDist = Integer.MAX_VALUE;
        for (int i = 0; i < colors.length; ++i) {
            TextFormatting formatting = colors[i];
            int paletteColor = formatting.func_211163_e();
            int distance = RGB2TextFormatting.distance(color, paletteColor);
            if (distance >= minDist) continue;
            minDistIndex = i;
            minDist = distance;
        }
        return colors[minDistIndex];
    }

    private static int distance(int color, int paletteColor) {
        int r1 = color >> 16 & 0xFF;
        int r2 = paletteColor >> 16 & 0xFF;
        int g1 = color >> 8 & 0xFF;
        int g2 = paletteColor >> 8 & 0xFF;
        int b1 = color & 0xFF;
        int b2 = paletteColor & 0xFF;
        return RGB2TextFormatting.sqr(r2 - r1) + RGB2TextFormatting.sqr(g2 - g1) + RGB2TextFormatting.sqr(b2 - b1);
    }

    private static TextFormatting[] initColors() {
        return (TextFormatting[])Arrays.stream(TextFormatting.values()).filter(TextFormatting::func_96302_c).toArray(TextFormatting[]::new);
    }

    private static int sqr(int n) {
        return n * n;
    }
}

